package maes

// |@@| C

import (
	"context"
	"gardening/src/dat/forms"
	"gardening/src/lib/form"
	"gardening/src/lib/in_context"
	"gardening/src/lib/out_extra"
	"gardening/src/lib/presenter"
	"gardening/src/mdl"
)

type CreatePlantMaeIn struct {
	Request CreatePlantMaeInReq
	Context in_context.InContext
}

type CreatePlantMaeOut struct {
	In       *CreatePlantMaeIn
	Response CreatePlantMaeOutRes
	Success  bool
	Ctx      context.Context
	Extra    out_extra.OutExtra
}

type CreatePlantMaeInReq struct {
	Form forms.CreatePlantForm `form:"form"`
}

type CreatePlantMaeOutRes struct {
	Plant      *mdl.Plant
	FormBag    *form.FormBag
	Form       forms.CreatePlantForm
	FormFields []*presenter.FormField
}
