package maes

// |@@| C

import (
	"context"
	"gardening/src/dat/forms"
	"gardening/src/lib/form"
	"gardening/src/lib/in_context"
	"gardening/src/lib/out_extra"
	"gardening/src/lib/presenter"
	"gardening/src/mdl"
)

type CreatePlantTaskMaeIn struct {
	Request CreatePlantTaskMaeInReq
	Context in_context.InContext
}

type CreatePlantTaskMaeOut struct {
	In       *CreatePlantTaskMaeIn
	Response CreatePlantTaskMaeOutRes
	Success  bool
	Ctx      context.Context
	Extra    out_extra.OutExtra
}

type CreatePlantTaskMaeInReq struct {
	Form forms.CreatePlantTaskForm `form:"form"`
}

type CreatePlantTaskMaeOutRes struct {
	PlantTask  *mdl.PlantTask
	FormBag    *form.FormBag
	Form       forms.CreatePlantTaskForm
	FormFields []*presenter.FormField
}
