package maes

// |@@| C

import (
	"context"
	"gardening/src/dat/forms"
	"gardening/src/lib/form"
	"gardening/src/lib/in_context"
	"gardening/src/lib/out_extra"
	"gardening/src/lib/presenter"
	"gardening/src/mdl"
)

type CreatePlantationMaeIn struct {
	Request CreatePlantationMaeInReq
	Context in_context.InContext
}

type CreatePlantationMaeOut struct {
	In       *CreatePlantationMaeIn
	Response CreatePlantationMaeOutRes
	Success  bool
	Ctx      context.Context
	Extra    out_extra.OutExtra
}

type CreatePlantationMaeInReq struct {
	Form forms.CreatePlantationForm `form:"form"`
}

type CreatePlantationMaeOutRes struct {
	Plantation *mdl.Plantation
	FormBag    *form.FormBag
	Form       forms.CreatePlantationForm
	FormFields []*presenter.FormField
}
