package maes

// |@@| C

import (
	"context"
	"gardening/src/dat/forms"
	"gardening/src/lib/form"
	"gardening/src/lib/in_context"
	"gardening/src/lib/out_extra"
	"gardening/src/lib/presenter"
	"gardening/src/mdl"
)

type CreateSeedProgramMaeIn struct {
	Request CreateSeedProgramMaeInReq
	Context in_context.InContext
}

type CreateSeedProgramMaeOut struct {
	In       *CreateSeedProgramMaeIn
	Response CreateSeedProgramMaeOutRes
	Success  bool
	Ctx      context.Context
	Extra    out_extra.OutExtra
}

type CreateSeedProgramMaeInReq struct {
	Form forms.CreateSeedProgramForm `form:"form"`
}

type CreateSeedProgramMaeOutRes struct {
	SeedProgram *mdl.SeedProgram
	FormBag     *form.FormBag
	Form        forms.CreateSeedProgramForm
	FormFields  []*presenter.FormField
}
