package maes

// |@@| C

import (
	"context"
	"gardening/src/dat/forms"
	"gardening/src/lib/form"
	"gardening/src/lib/in_context"
	"gardening/src/lib/out_extra"
	"gardening/src/lib/presenter"
	"gardening/src/mdl"
)

type CreateUserMaeIn struct {
	Request CreateUserMaeInReq
	Context in_context.InContext
}

type CreateUserMaeOut struct {
	In       *CreateUserMaeIn
	Response CreateUserMaeOutRes
	Success  bool
	Ctx      context.Context
	Extra    out_extra.OutExtra
}

type CreateUserMaeInReq struct {
	Form forms.CreateUserForm `form:"form"`
}

type CreateUserMaeOutRes struct {
	User       *mdl.User
	FormBag    *form.FormBag
	Form       forms.CreateUserForm
	FormFields []*presenter.FormField
}
