package maes

// |@@| C

import (
	"context"
	"gardening/src/dat/forms"
	"gardening/src/lib/form"
	"gardening/src/lib/in_context"
	"gardening/src/lib/out_extra"
	"gardening/src/lib/presenter"
	"gardening/src/mdl"
)

type EditGardenMaeIn struct {
	Request EditGardenMaeInReq
	Context in_context.InContext
}

type EditGardenMaeOut struct {
	In       *EditGardenMaeIn
	Response EditGardenMaeOutRes
	Success  bool
	Ctx      context.Context
	Extra    out_extra.OutExtra
}

type EditGardenMaeInReq struct {
	Form forms.UpdateGardenForm `form:"form"`
}

type EditGardenMaeOutRes struct {
	FormFields []*presenter.FormField
	FormBag    *form.FormBag
	Form       forms.UpdateGardenForm
	Doc        *mdl.Garden
}
