package maes

// |@@| C

import (
	"context"
	"gardening/src/dat/forms"
	"gardening/src/lib/form"
	"gardening/src/lib/in_context"
	"gardening/src/lib/out_extra"
	"gardening/src/lib/presenter"
	"gardening/src/mdl"
)

type EditGardenTaskMaeIn struct {
	Request EditGardenTaskMaeInReq
	Context in_context.InContext
}

type EditGardenTaskMaeOut struct {
	In       *EditGardenTaskMaeIn
	Response EditGardenTaskMaeOutRes
	Success  bool
	Ctx      context.Context
	Extra    out_extra.OutExtra
}

type EditGardenTaskMaeInReq struct {
	Form forms.UpdateGardenTaskForm `form:"form"`
}

type EditGardenTaskMaeOutRes struct {
	FormFields []*presenter.FormField
	FormBag    *form.FormBag
	Form       forms.UpdateGardenTaskForm
	Doc        *mdl.GardenTask
}
