package maes

// |@@| C

import (
	"context"
	"gardening/src/dat/forms"
	"gardening/src/lib/form"
	"gardening/src/lib/in_context"
	"gardening/src/lib/out_extra"
	"gardening/src/lib/presenter"
	"gardening/src/mdl"
)

type EditPlantMaeIn struct {
	Request EditPlantMaeInReq
	Context in_context.InContext
}

type EditPlantMaeOut struct {
	In       *EditPlantMaeIn
	Response EditPlantMaeOutRes
	Success  bool
	Ctx      context.Context
	Extra    out_extra.OutExtra
}

type EditPlantMaeInReq struct {
	Form forms.UpdatePlantForm `form:"form"`
}

type EditPlantMaeOutRes struct {
	FormFields []*presenter.FormField
	FormBag    *form.FormBag
	Form       forms.UpdatePlantForm
	Doc        *mdl.Plant
}
