package maes

// |@@| C

import (
	"context"
	"gardening/src/dat/forms"
	"gardening/src/lib/form"
	"gardening/src/lib/in_context"
	"gardening/src/lib/out_extra"
	"gardening/src/lib/presenter"
	"gardening/src/mdl"
)

type EditPlantTaskMaeIn struct {
	Request EditPlantTaskMaeInReq
	Context in_context.InContext
}

type EditPlantTaskMaeOut struct {
	In       *EditPlantTaskMaeIn
	Response EditPlantTaskMaeOutRes
	Success  bool
	Ctx      context.Context
	Extra    out_extra.OutExtra
}

type EditPlantTaskMaeInReq struct {
	Form forms.UpdatePlantTaskForm `form:"form"`
}

type EditPlantTaskMaeOutRes struct {
	FormFields []*presenter.FormField
	FormBag    *form.FormBag
	Form       forms.UpdatePlantTaskForm
	Doc        *mdl.PlantTask
}
