package maes

// |@@| C

import (
	"context"
	"gardening/src/dat/forms"
	"gardening/src/lib/form"
	"gardening/src/lib/in_context"
	"gardening/src/lib/out_extra"
	"gardening/src/lib/presenter"
	"gardening/src/mdl"
)

type EditPlantationMaeIn struct {
	Request EditPlantationMaeInReq
	Context in_context.InContext
}

type EditPlantationMaeOut struct {
	In       *EditPlantationMaeIn
	Response EditPlantationMaeOutRes
	Success  bool
	Ctx      context.Context
	Extra    out_extra.OutExtra
}

type EditPlantationMaeInReq struct {
	Form forms.UpdatePlantationForm `form:"form"`
}

type EditPlantationMaeOutRes struct {
	FormFields []*presenter.FormField
	FormBag    *form.FormBag
	Form       forms.UpdatePlantationForm
	Doc        *mdl.Plantation
}
