package maes

// |@@| C

import (
	"context"
	"gardening/src/dat/forms"
	"gardening/src/lib/form"
	"gardening/src/lib/in_context"
	"gardening/src/lib/out_extra"
	"gardening/src/lib/presenter"
	"gardening/src/mdl"
)

type EditSeedProgramMaeIn struct {
	Request EditSeedProgramMaeInReq
	Context in_context.InContext
}

type EditSeedProgramMaeOut struct {
	In       *EditSeedProgramMaeIn
	Response EditSeedProgramMaeOutRes
	Success  bool
	Ctx      context.Context
	Extra    out_extra.OutExtra
}

type EditSeedProgramMaeInReq struct {
	Form forms.UpdateSeedProgramForm `form:"form"`
}

type EditSeedProgramMaeOutRes struct {
	FormFields []*presenter.FormField
	FormBag    *form.FormBag
	Form       forms.UpdateSeedProgramForm
	Doc        *mdl.SeedProgram
}
