package maes

// |@@| C

import (
	"context"
	"gardening/src/dat/forms"
	"gardening/src/lib/form"
	"gardening/src/lib/in_context"
	"gardening/src/lib/out_extra"
	"gardening/src/lib/presenter"
	"gardening/src/mdl"
)

type EditUserMaeIn struct {
	Request EditUserMaeInReq
	Context in_context.InContext
}

type EditUserMaeOut struct {
	In       *EditUserMaeIn
	Response EditUserMaeOutRes
	Success  bool
	Ctx      context.Context
	Extra    out_extra.OutExtra
}

type EditUserMaeInReq struct {
	Form forms.UpdateUserForm `form:"form"`
}

type EditUserMaeOutRes struct {
	FormFields []*presenter.FormField
	FormBag    *form.FormBag
	Form       forms.UpdateUserForm
	Doc        *mdl.User
}
