package maes

// |@@| C

import (
	"context"
	"gardening/src/lib/fetcher"
	"gardening/src/lib/in_context"
	"gardening/src/lib/out_extra"
	"gardening/src/lib/presenter"
	"gardening/src/mdl"
)

type ListGardenTasksMaeIn struct {
	Request ListGardenTasksMaeInReq
	Context in_context.InContext
}

type ListGardenTasksMaeOut struct {
	In       *ListGardenTasksMaeIn
	Response ListGardenTasksMaeOutRes
	Success  bool
	Ctx      context.Context
	Extra    out_extra.OutExtra
}

type ListGardenTasksMaeInReq struct {
	Page    int                 `form:"page" json:"page"`
	Filters []fetcher.RawFilter `form:"filters"`
	Columns []presenter.Column  `form:"columns"`
}

type ListGardenTasksMaeOutRes struct {
	GardenTasks           []*mdl.GardenTask
	GardenTasksPagination *fetcher.FetcherPagination
	List                  struct {
		Docs    []*mdl.GardenTask
		Columns []*presenter.Column
	}
}
