package maes

// |@@| C

import (
	"context"
	"gardening/src/lib/fetcher"
	"gardening/src/lib/in_context"
	"gardening/src/lib/out_extra"
	"gardening/src/lib/presenter"
	"gardening/src/mdl"
)

type ListGardensMaeIn struct {
	Request ListGardensMaeInReq
	Context in_context.InContext
}

type ListGardensMaeOut struct {
	In       *ListGardensMaeIn
	Response ListGardensMaeOutRes
	Success  bool
	Ctx      context.Context
	Extra    out_extra.OutExtra
}

type ListGardensMaeInReq struct {
	Page    int                 `form:"page" json:"page"`
	Filters []fetcher.RawFilter `form:"filters"`
	Columns []presenter.Column  `form:"columns"`
}

type ListGardensMaeOutRes struct {
	Gardens           []*mdl.Garden
	GardensPagination *fetcher.FetcherPagination
	List              struct {
		Docs    []*mdl.Garden
		Columns []*presenter.Column
	}
}
