package maes

// |@@| C

import (
	"context"
	"gardening/src/lib/fetcher"
	"gardening/src/lib/in_context"
	"gardening/src/lib/out_extra"
	"gardening/src/lib/presenter"
	"gardening/src/mdl"
)

type ListPlantTasksMaeIn struct {
	Request ListPlantTasksMaeInReq
	Context in_context.InContext
}

type ListPlantTasksMaeOut struct {
	In       *ListPlantTasksMaeIn
	Response ListPlantTasksMaeOutRes
	Success  bool
	Ctx      context.Context
	Extra    out_extra.OutExtra
}

type ListPlantTasksMaeInReq struct {
	Page    int                 `form:"page" json:"page"`
	Filters []fetcher.RawFilter `form:"filters"`
	Columns []presenter.Column  `form:"columns"`
}

type ListPlantTasksMaeOutRes struct {
	PlantTasks           []*mdl.PlantTask
	PlantTasksPagination *fetcher.FetcherPagination
	List                 struct {
		Docs    []*mdl.PlantTask
		Columns []*presenter.Column
	}
}
