package maes

// |@@| C

import (
	"context"
	"gardening/src/lib/fetcher"
	"gardening/src/lib/in_context"
	"gardening/src/lib/out_extra"
	"gardening/src/lib/presenter"
	"gardening/src/mdl"
)

type ListPlantationsMaeIn struct {
	Request ListPlantationsMaeInReq
	Context in_context.InContext
}

type ListPlantationsMaeOut struct {
	In       *ListPlantationsMaeIn
	Response ListPlantationsMaeOutRes
	Success  bool
	Ctx      context.Context
	Extra    out_extra.OutExtra
}

type ListPlantationsMaeInReq struct {
	Page    int                 `form:"page" json:"page"`
	Filters []fetcher.RawFilter `form:"filters"`
	Columns []presenter.Column  `form:"columns"`
}

type ListPlantationsMaeOutRes struct {
	Plantations           []*mdl.Plantation
	PlantationsPagination *fetcher.FetcherPagination
	List                  struct {
		Docs    []*mdl.Plantation
		Columns []*presenter.Column
	}
}
