package maes

// |@@| C

import (
	"context"
	"gardening/src/lib/fetcher"
	"gardening/src/lib/in_context"
	"gardening/src/lib/out_extra"
	"gardening/src/lib/presenter"
	"gardening/src/mdl"
)

type ListPlantsMaeIn struct {
	Request ListPlantsMaeInReq
	Context in_context.InContext
}

type ListPlantsMaeOut struct {
	In       *ListPlantsMaeIn
	Response ListPlantsMaeOutRes
	Success  bool
	Ctx      context.Context
	Extra    out_extra.OutExtra
}

type ListPlantsMaeInReq struct {
	Page    int                 `form:"page" json:"page"`
	Filters []fetcher.RawFilter `form:"filters"`
	Columns []presenter.Column  `form:"columns"`
}

type ListPlantsMaeOutRes struct {
	Plants           []*mdl.Plant
	PlantsPagination *fetcher.FetcherPagination
	List             struct {
		Docs    []*mdl.Plant
		Columns []*presenter.Column
	}
}
