package maes

// |@@| C

import (
	"context"
	"gardening/src/lib/fetcher"
	"gardening/src/lib/in_context"
	"gardening/src/lib/out_extra"
	"gardening/src/lib/presenter"
	"gardening/src/mdl"
)

type ListSeedProgramsMaeIn struct {
	Request ListSeedProgramsMaeInReq
	Context in_context.InContext
}

type ListSeedProgramsMaeOut struct {
	In       *ListSeedProgramsMaeIn
	Response ListSeedProgramsMaeOutRes
	Success  bool
	Ctx      context.Context
	Extra    out_extra.OutExtra
}

type ListSeedProgramsMaeInReq struct {
	Page    int                 `form:"page" json:"page"`
	Filters []fetcher.RawFilter `form:"filters"`
	Columns []presenter.Column  `form:"columns"`
}

type ListSeedProgramsMaeOutRes struct {
	SeedPrograms           []*mdl.SeedProgram
	SeedProgramsPagination *fetcher.FetcherPagination
	List                   struct {
		Docs    []*mdl.SeedProgram
		Columns []*presenter.Column
	}
}
