package maes

// |@@| C

import (
	"context"
	"gardening/src/lib/fetcher"
	"gardening/src/lib/in_context"
	"gardening/src/lib/out_extra"
	"gardening/src/lib/presenter"
	"gardening/src/mdl"
)

type ListUsersMaeIn struct {
	Request ListUsersMaeInReq
	Context in_context.InContext
}

type ListUsersMaeOut struct {
	In       *ListUsersMaeIn
	Response ListUsersMaeOutRes
	Success  bool
	Ctx      context.Context
	Extra    out_extra.OutExtra
}

type ListUsersMaeInReq struct {
	Page    int                 `form:"page" json:"page"`
	Filters []fetcher.RawFilter `form:"filters"`
	Columns []presenter.Column  `form:"columns"`
}

type ListUsersMaeOutRes struct {
	Users           []*mdl.User
	UsersPagination *fetcher.FetcherPagination
	List            struct {
		Docs    []*mdl.User
		Columns []*presenter.Column
	}
}
