package maes

// |@@| C

import (
	"context"
	"gardening/src/dat/forms"
	"gardening/src/lib/form"
	"gardening/src/lib/in_context"
	"gardening/src/lib/out_extra"
	"gardening/src/lib/presenter"
)

type NewGardenMaeIn struct {
	Request NewGardenMaeInReq
	Context in_context.InContext
}

type NewGardenMaeOut struct {
	In       *NewGardenMaeIn
	Response NewGardenMaeOutRes
	Success  bool
	Ctx      context.Context
	Extra    out_extra.OutExtra
}

type NewGardenMaeInReq struct {
	Form forms.CreateGardenForm `form:"form"`
}

type NewGardenMaeOutRes struct {
	FormBag    *form.FormBag
	Form       forms.CreateGardenForm
	FormFields []*presenter.FormField
}
