package maes

// |@@| C

import (
	"context"
	"gardening/src/dat/forms"
	"gardening/src/lib/form"
	"gardening/src/lib/in_context"
	"gardening/src/lib/out_extra"
	"gardening/src/lib/presenter"
)

type NewGardenTaskMaeIn struct {
	Request NewGardenTaskMaeInReq
	Context in_context.InContext
}

type NewGardenTaskMaeOut struct {
	In       *NewGardenTaskMaeIn
	Response NewGardenTaskMaeOutRes
	Success  bool
	Ctx      context.Context
	Extra    out_extra.OutExtra
}

type NewGardenTaskMaeInReq struct {
	Form forms.CreateGardenTaskForm `form:"form"`
}

type NewGardenTaskMaeOutRes struct {
	FormBag    *form.FormBag
	Form       forms.CreateGardenTaskForm
	FormFields []*presenter.FormField
}
