package maes

// |@@| C

import (
	"context"
	"gardening/src/dat/forms"
	"gardening/src/lib/form"
	"gardening/src/lib/in_context"
	"gardening/src/lib/out_extra"
	"gardening/src/lib/presenter"
)

type NewPlantMaeIn struct {
	Request NewPlantMaeInReq
	Context in_context.InContext
}

type NewPlantMaeOut struct {
	In       *NewPlantMaeIn
	Response NewPlantMaeOutRes
	Success  bool
	Ctx      context.Context
	Extra    out_extra.OutExtra
}

type NewPlantMaeInReq struct {
	Form forms.CreatePlantForm `form:"form"`
}

type NewPlantMaeOutRes struct {
	FormBag    *form.FormBag
	Form       forms.CreatePlantForm
	FormFields []*presenter.FormField
}
