package maes

// |@@| C

import (
	"context"
	"gardening/src/dat/forms"
	"gardening/src/lib/form"
	"gardening/src/lib/in_context"
	"gardening/src/lib/out_extra"
	"gardening/src/lib/presenter"
)

type NewPlantTaskMaeIn struct {
	Request NewPlantTaskMaeInReq
	Context in_context.InContext
}

type NewPlantTaskMaeOut struct {
	In       *NewPlantTaskMaeIn
	Response NewPlantTaskMaeOutRes
	Success  bool
	Ctx      context.Context
	Extra    out_extra.OutExtra
}

type NewPlantTaskMaeInReq struct {
	Form forms.CreatePlantTaskForm `form:"form"`
}

type NewPlantTaskMaeOutRes struct {
	FormBag    *form.FormBag
	Form       forms.CreatePlantTaskForm
	FormFields []*presenter.FormField
}
