package maes

// |@@| C

import (
	"context"
	"gardening/src/dat/forms"
	"gardening/src/lib/form"
	"gardening/src/lib/in_context"
	"gardening/src/lib/out_extra"
	"gardening/src/lib/presenter"
)

type NewPlantationMaeIn struct {
	Request NewPlantationMaeInReq
	Context in_context.InContext
}

type NewPlantationMaeOut struct {
	In       *NewPlantationMaeIn
	Response NewPlantationMaeOutRes
	Success  bool
	Ctx      context.Context
	Extra    out_extra.OutExtra
}

type NewPlantationMaeInReq struct {
	Form forms.CreatePlantationForm `form:"form"`
}

type NewPlantationMaeOutRes struct {
	FormBag    *form.FormBag
	Form       forms.CreatePlantationForm
	FormFields []*presenter.FormField
}
