package maes

// |@@| C

import (
	"context"
	"gardening/src/dat/forms"
	"gardening/src/lib/form"
	"gardening/src/lib/in_context"
	"gardening/src/lib/out_extra"
	"gardening/src/lib/presenter"
)

type NewSeedProgramMaeIn struct {
	Request NewSeedProgramMaeInReq
	Context in_context.InContext
}

type NewSeedProgramMaeOut struct {
	In       *NewSeedProgramMaeIn
	Response NewSeedProgramMaeOutRes
	Success  bool
	Ctx      context.Context
	Extra    out_extra.OutExtra
}

type NewSeedProgramMaeInReq struct {
	Form forms.CreateSeedProgramForm `form:"form"`
}

type NewSeedProgramMaeOutRes struct {
	FormBag    *form.FormBag
	Form       forms.CreateSeedProgramForm
	FormFields []*presenter.FormField
}
