package maes

// |@@| C

import (
	"context"
	"gardening/src/dat/forms"
	"gardening/src/lib/form"
	"gardening/src/lib/in_context"
	"gardening/src/lib/out_extra"
	"gardening/src/lib/presenter"
)

type NewUserMaeIn struct {
	Request NewUserMaeInReq
	Context in_context.InContext
}

type NewUserMaeOut struct {
	In       *NewUserMaeIn
	Response NewUserMaeOutRes
	Success  bool
	Ctx      context.Context
	Extra    out_extra.OutExtra
}

type NewUserMaeInReq struct {
	Form forms.CreateUserForm `form:"form"`
}

type NewUserMaeOutRes struct {
	FormBag    *form.FormBag
	Form       forms.CreateUserForm
	FormFields []*presenter.FormField
}
