package maes

// |@@| C

import (
	"context"
	"gardening/src/dat/forms"
	"gardening/src/lib/form"
	"gardening/src/lib/in_context"
	"gardening/src/lib/out_extra"
	"gardening/src/lib/presenter"
)

type PerformAnalyseMaeIn struct {
	Request PerformAnalyseMaeInReq
	Context in_context.InContext
}

type PerformAnalyseMaeOut struct {
	In       *PerformAnalyseMaeIn
	Response PerformAnalyseMaeOutRes
	Success  bool
	Ctx      context.Context
	Extra    out_extra.OutExtra
}

type PerformAnalyseMaeInReq struct {
	Form forms.PerformAnalyseForm `form:"form"`
}

type PerformAnalyseMaeOutRes struct {
	FormScope struct {
		Form       forms.PerformAnalyseForm
		FormFields []*presenter.FormField
		FormBag    *form.FormBag
	}
}
