package maes

// |@@| C

import (
	"context"
	"gardening/src/dat/forms"
	"gardening/src/lib/form"
	"gardening/src/lib/in_context"
	"gardening/src/lib/out_extra"
	"gardening/src/lib/presenter"
)

type PerformImagesRoutineMaeIn struct {
	Request PerformImagesRoutineMaeInReq
	Context in_context.InContext
}

type PerformImagesRoutineMaeOut struct {
	In       *PerformImagesRoutineMaeIn
	Response PerformImagesRoutineMaeOutRes
	Success  bool
	Ctx      context.Context
	Extra    out_extra.OutExtra
}

type PerformImagesRoutineMaeInReq struct {
	Form forms.PerformImagesRoutineForm `form:"form"`
}

type PerformImagesRoutineMaeOutRes struct {
	FormScope struct {
		Form       forms.PerformImagesRoutineForm
		FormFields []*presenter.FormField
		FormBag    *form.FormBag
	}
}
