package maes

// |@@| C

import (
	"context"
	"gardening/src/dat/forms"
	"gardening/src/lib/form"
	"gardening/src/lib/in_context"
	"gardening/src/lib/out_extra"
	"gardening/src/lib/presenter"
)

type PerformRenewOrdersMaeIn struct {
	Request PerformRenewOrdersMaeInReq
	Context in_context.InContext
}

type PerformRenewOrdersMaeOut struct {
	In       *PerformRenewOrdersMaeIn
	Response PerformRenewOrdersMaeOutRes
	Success  bool
	Ctx      context.Context
	Extra    out_extra.OutExtra
}

type PerformRenewOrdersMaeInReq struct {
	Form forms.PerformRenewOrdersForm `form:"form"`
}

type PerformRenewOrdersMaeOutRes struct {
	FormScope struct {
		Form       forms.PerformRenewOrdersForm
		FormFields []*presenter.FormField
		FormBag    *form.FormBag
	}
}
