package maes

// |@@| C

import (
	"context"
	"gardening/src/dat/forms"
	"gardening/src/lib/form"
	"gardening/src/lib/in_context"
	"gardening/src/lib/out_extra"
	"gardening/src/lib/presenter"
)

type SeeEventsMaeIn struct {
	Request SeeEventsMaeInReq
	Context in_context.InContext
}

type SeeEventsMaeOut struct {
	In       *SeeEventsMaeIn
	Response SeeEventsMaeOutRes
	Success  bool
	Ctx      context.Context
	Extra    out_extra.OutExtra
}

type SeeEventsMaeInReq struct {
	Form forms.PerformEventsForm `form:"form"`
}

type SeeEventsMaeOutRes struct {
	FormScope struct {
		Form       forms.PerformEventsForm
		FormFields []*presenter.FormField
		FormBag    *form.FormBag
	}
}
