package maes

// |@@| C

import (
	"context"
	"gardening/src/dat/forms"
	"gardening/src/lib/form"
	"gardening/src/lib/in_context"
	"gardening/src/lib/out_extra"
	"gardening/src/lib/presenter"
)

type SeePlannerMaeIn struct {
	Request SeePlannerMaeInReq
	Context in_context.InContext
}

type SeePlannerMaeOut struct {
	In       *SeePlannerMaeIn
	Response SeePlannerMaeOutRes
	Success  bool
	Ctx      context.Context
	Extra    out_extra.OutExtra
}

type SeePlannerMaeInReq struct {
	Form forms.PerformPlannerForm `form:"form"`
}

type SeePlannerMaeOutRes struct {
	FormScope struct {
		Form       forms.PerformPlannerForm
		FormFields []*presenter.FormField
		FormBag    *form.FormBag
	}
}
