package maes

// |@@| C

import (
	"context"
	"gardening/src/dat/forms"
	"gardening/src/lib/form"
	"gardening/src/lib/in_context"
	"gardening/src/lib/out_extra"
	"gardening/src/lib/presenter"
)

type SeeRenewOrdersMaeIn struct {
	Request SeeRenewOrdersMaeInReq
	Context in_context.InContext
}

type SeeRenewOrdersMaeOut struct {
	In       *SeeRenewOrdersMaeIn
	Response SeeRenewOrdersMaeOutRes
	Success  bool
	Ctx      context.Context
	Extra    out_extra.OutExtra
}

type SeeRenewOrdersMaeInReq struct {
	Form forms.PerformRenewOrdersForm `form:"form"`
}

type SeeRenewOrdersMaeOutRes struct {
	FormScope struct {
		Form       forms.PerformRenewOrdersForm
		FormFields []*presenter.FormField
		FormBag    *form.FormBag
	}
}
