package maes

// |@@| C

import (
	"context"
	"gardening/src/lib/fetcher"
	"gardening/src/lib/in_context"
	"gardening/src/lib/out_extra"
	"gardening/src/mdl"
)

type ShowGardenMaeIn struct {
	Request ShowGardenMaeInReq
	Context in_context.InContext
}

type ShowGardenMaeOut struct {
	In       *ShowGardenMaeIn
	Response ShowGardenMaeOutRes
	Success  bool
	Ctx      context.Context
	Extra    out_extra.OutExtra
}

type ShowGardenMaeInReq struct {
	Id string `form:"id" json:"id"`
}

type ShowGardenMaeOutRes struct {
	Garden *mdl.Garden
	Events []*mdl.Event
	Show   struct {
		Doc        *mdl.Garden
		Embeddings struct {
		}
	}
	GardenTasks           []*mdl.GardenTask
	GardenTasksPagination *fetcher.FetcherPagination
	Plantations           []*mdl.Plantation
	PlantationsPagination *fetcher.FetcherPagination
}
