package maes

// |@@| C

import (
	"context"
	"gardening/src/lib/fetcher"
	"gardening/src/lib/in_context"
	"gardening/src/lib/out_extra"
	"gardening/src/mdl"
)

type ShowPlantMaeIn struct {
	Request ShowPlantMaeInReq
	Context in_context.InContext
}

type ShowPlantMaeOut struct {
	In       *ShowPlantMaeIn
	Response ShowPlantMaeOutRes
	Success  bool
	Ctx      context.Context
	Extra    out_extra.OutExtra
}

type ShowPlantMaeInReq struct {
	Id string `form:"id" json:"id"`
}

type ShowPlantMaeOutRes struct {
	Plant  *mdl.Plant
	Events []*mdl.Event
	Show   struct {
		Doc        *mdl.Plant
		Embeddings struct {
		}
	}
	PlantTasks             []*mdl.PlantTask
	PlantTasksPagination   *fetcher.FetcherPagination
	Plantations            []*mdl.Plantation
	PlantationsPagination  *fetcher.FetcherPagination
	SeedPrograms           []*mdl.SeedProgram
	SeedProgramsPagination *fetcher.FetcherPagination
}
