package maes

// |@@| C

import (
	"context"
	"gardening/src/lib/fetcher"
	"gardening/src/lib/in_context"
	"gardening/src/lib/out_extra"
	"gardening/src/mdl"
)

type ShowPlantationMaeIn struct {
	Request ShowPlantationMaeInReq
	Context in_context.InContext
}

type ShowPlantationMaeOut struct {
	In       *ShowPlantationMaeIn
	Response ShowPlantationMaeOutRes
	Success  bool
	Ctx      context.Context
	Extra    out_extra.OutExtra
}

type ShowPlantationMaeInReq struct {
	Id string `form:"id" json:"id"`
}

type ShowPlantationMaeOutRes struct {
	Plantation *mdl.Plantation
	Events     []*mdl.Event
	Show       struct {
		Doc        *mdl.Plantation
		Embeddings struct {
		}
	}
	GardenTasks           []*mdl.GardenTask
	GardenTasksPagination *fetcher.FetcherPagination
}
