package maes

// |@@| C

import (
	"context"
	"gardening/src/lib/in_context"
	"gardening/src/lib/out_extra"
	"gardening/src/mdl"
)

type ShowUserMaeIn struct {
	Request ShowUserMaeInReq
	Context in_context.InContext
}

type ShowUserMaeOut struct {
	In       *ShowUserMaeIn
	Response ShowUserMaeOutRes
	Success  bool
	Ctx      context.Context
	Extra    out_extra.OutExtra
}

type ShowUserMaeInReq struct {
	Id string `form:"id" json:"id"`
}

type ShowUserMaeOutRes struct {
	User   *mdl.User
	Events []*mdl.Event
	Show   struct {
		Doc        *mdl.User
		Embeddings struct {
		}
	}
}
