package maes

// |@@| C

import (
	"context"
	"gardening/src/dat/forms"
	"gardening/src/lib/form"
	"gardening/src/lib/in_context"
	"gardening/src/lib/out_extra"
	"gardening/src/lib/presenter"
	"gardening/src/mdl"
)

type UpdateGardenMaeIn struct {
	Request UpdateGardenMaeInReq
	Context in_context.InContext
}

type UpdateGardenMaeOut struct {
	In       *UpdateGardenMaeIn
	Response UpdateGardenMaeOutRes
	Success  bool
	Ctx      context.Context
	Extra    out_extra.OutExtra
}

type UpdateGardenMaeInReq struct {
	Form  forms.UpdateGardenForm `form:"form"`
	Files UpdateGardenMaeFiles   `form:"files"`
}

type UpdateGardenMaeOutRes struct {
	Garden     *mdl.Garden
	FormBag    *form.FormBag
	FormFields []*presenter.FormField
}

type UpdateGardenMaeFiles struct {
	Picture string
}
