package maes

// |@@| C

import (
	"context"
	"gardening/src/dat/forms"
	"gardening/src/lib/form"
	"gardening/src/lib/in_context"
	"gardening/src/lib/out_extra"
	"gardening/src/lib/presenter"
	"gardening/src/mdl"
)

type UpdateGardenTaskMaeIn struct {
	Request UpdateGardenTaskMaeInReq
	Context in_context.InContext
}

type UpdateGardenTaskMaeOut struct {
	In       *UpdateGardenTaskMaeIn
	Response UpdateGardenTaskMaeOutRes
	Success  bool
	Ctx      context.Context
	Extra    out_extra.OutExtra
}

type UpdateGardenTaskMaeInReq struct {
	Form forms.UpdateGardenTaskForm `form:"form"`
}

type UpdateGardenTaskMaeOutRes struct {
	GardenTask *mdl.GardenTask
	FormBag    *form.FormBag
	FormFields []*presenter.FormField
}
