package maes

// |@@| C

import (
	"context"
	"gardening/src/dat/forms"
	"gardening/src/lib/form"
	"gardening/src/lib/in_context"
	"gardening/src/lib/out_extra"
	"gardening/src/lib/presenter"
	"gardening/src/mdl"
)

type UpdatePlantMaeIn struct {
	Request UpdatePlantMaeInReq
	Context in_context.InContext
}

type UpdatePlantMaeOut struct {
	In       *UpdatePlantMaeIn
	Response UpdatePlantMaeOutRes
	Success  bool
	Ctx      context.Context
	Extra    out_extra.OutExtra
}

type UpdatePlantMaeInReq struct {
	Form forms.UpdatePlantForm `form:"form"`
}

type UpdatePlantMaeOutRes struct {
	Plant      *mdl.Plant
	FormBag    *form.FormBag
	FormFields []*presenter.FormField
}
