package maes

// |@@| C

import (
	"context"
	"gardening/src/dat/forms"
	"gardening/src/lib/form"
	"gardening/src/lib/in_context"
	"gardening/src/lib/out_extra"
	"gardening/src/lib/presenter"
	"gardening/src/mdl"
)

type UpdatePlantTaskMaeIn struct {
	Request UpdatePlantTaskMaeInReq
	Context in_context.InContext
}

type UpdatePlantTaskMaeOut struct {
	In       *UpdatePlantTaskMaeIn
	Response UpdatePlantTaskMaeOutRes
	Success  bool
	Ctx      context.Context
	Extra    out_extra.OutExtra
}

type UpdatePlantTaskMaeInReq struct {
	Form forms.UpdatePlantTaskForm `form:"form"`
}

type UpdatePlantTaskMaeOutRes struct {
	PlantTask  *mdl.PlantTask
	FormBag    *form.FormBag
	FormFields []*presenter.FormField
}
