package maes

// |@@| C

import (
	"context"
	"gardening/src/dat/forms"
	"gardening/src/lib/form"
	"gardening/src/lib/in_context"
	"gardening/src/lib/out_extra"
	"gardening/src/lib/presenter"
	"gardening/src/mdl"
)

type UpdatePlantationMaeIn struct {
	Request UpdatePlantationMaeInReq
	Context in_context.InContext
}

type UpdatePlantationMaeOut struct {
	In       *UpdatePlantationMaeIn
	Response UpdatePlantationMaeOutRes
	Success  bool
	Ctx      context.Context
	Extra    out_extra.OutExtra
}

type UpdatePlantationMaeInReq struct {
	Form forms.UpdatePlantationForm `form:"form"`
}

type UpdatePlantationMaeOutRes struct {
	Plantation *mdl.Plantation
	FormBag    *form.FormBag
	FormFields []*presenter.FormField
}
