package maes

// |@@| C

import (
	"context"
	"gardening/src/dat/forms"
	"gardening/src/lib/form"
	"gardening/src/lib/in_context"
	"gardening/src/lib/out_extra"
	"gardening/src/lib/presenter"
	"gardening/src/mdl"
)

type UpdateSeedProgramMaeIn struct {
	Request UpdateSeedProgramMaeInReq
	Context in_context.InContext
}

type UpdateSeedProgramMaeOut struct {
	In       *UpdateSeedProgramMaeIn
	Response UpdateSeedProgramMaeOutRes
	Success  bool
	Ctx      context.Context
	Extra    out_extra.OutExtra
}

type UpdateSeedProgramMaeInReq struct {
	Form forms.UpdateSeedProgramForm `form:"form"`
}

type UpdateSeedProgramMaeOutRes struct {
	SeedProgram *mdl.SeedProgram
	FormBag     *form.FormBag
	FormFields  []*presenter.FormField
}
