package maes

// |@@| C

import (
	"context"
	"gardening/src/dat/forms"
	"gardening/src/lib/form"
	"gardening/src/lib/in_context"
	"gardening/src/lib/out_extra"
	"gardening/src/lib/presenter"
	"gardening/src/mdl"
)

type UpdateUserMaeIn struct {
	Request UpdateUserMaeInReq
	Context in_context.InContext
}

type UpdateUserMaeOut struct {
	In       *UpdateUserMaeIn
	Response UpdateUserMaeOutRes
	Success  bool
	Ctx      context.Context
	Extra    out_extra.OutExtra
}

type UpdateUserMaeInReq struct {
	Form forms.UpdateUserForm `form:"form"`
}

type UpdateUserMaeOutRes struct {
	User       *mdl.User
	FormBag    *form.FormBag
	FormFields []*presenter.FormField
}
