package string_converter

import "strings"

type CaseConverter struct {
}

func (this *CaseConverter) Humanize(s string) string {
	return strings.ReplaceAll(s, "_", " ")
}

func (this *CaseConverter) Capitalize(s string) string {
	if len(s) == 0 {
		return s
	}
	return strings.ToUpper(string(s[0])) + s[1:]
}

func (this *CaseConverter) Titleize(s string) string {
	words := strings.Fields(s)
	for i, word := range words {
		words[i] = strings.ToUpper(string(word[0])) + word[1:]
	}
	return strings.Join(words, " ")
}

func (this *CaseConverter) HumanizeCapitalize(s string) string {
	return this.Capitalize(this.Humanize(s))
}

func (this *CaseConverter) HumanizeTitleize(s string) string {
	return this.Titleize(this.Humanize(s))
}
