package dotor

// |@@| C

import (
	"context"
	"gardening/src/lib"
	"gardening/src/lib/config"
	"gardening/src/lib/filesystem"
	"gardening/src/lib/operating_system"
	"strings"
)

type Dotor struct {
	Config                   *config.Config
	OperatingSystemInterface operating_system.OperatingSystemInterface
	Filesystem               *filesystem.Filesystem
}

func (this *Dotor) Act(ctx context.Context) {
	envDir := this.Config.GetRootDir() + "/config/envs/env.dot"
	s := string(this.Filesystem.MustReadFile(ctx, envDir))
	lines := strings.Split(s, "\n")
	for _, line := range lines {
		if line == "" {
			continue
		}
		key, value, found := strings.Cut(line, "=")
		if !found {
			lib.Panic("Invalid dot file for line " + line)
		}
		err := this.OperatingSystemInterface.Setenv(ctx, key, value)
		lib.Poe(err)
	}
	println("Configuration loaded from " + envDir)
}
