package filter

type Filter interface {
	GetKey() string
}

type Filters []Filter

func (this *Filters) Add(filter Filter) {
	*this = append(*this, filter)
}

func (this *Filters) AddIdFilter(key string) {
	this.Add(&IdFilter{key})
}

func (this *Filters) AddIntegerFilter(key string) {
	this.Add(&IntegerFilter{key})
}

func (this *Filters) AddStringFilter(key string) {
	this.Add(&StringFilter{key})
}

func (this *Filters) AddBooleanFilter(key string) {
	this.Add(&BooleanFilter{key})
}

func (this *Filters) AddRelationIdFilter(key string) {
	this.Add(&RelationIdFilter{key})
}

type IdFilter struct {
	Key string
}

func (this *IdFilter) GetKey() string {
	return this.Key
}

type IntegerFilter struct {
	Key string
}

func (this *IntegerFilter) GetKey() string {
	return this.Key
}

type StringFilter struct {
	Key string
}

func (this *StringFilter) GetKey() string {
	return this.Key
}

type BooleanFilter struct {
	Key string
}

func (this *BooleanFilter) GetKey() string {
	return this.Key
}

type RelationIdFilter struct {
	Key string
}

func (this *RelationIdFilter) GetKey() string {
	return this.Key
}
