package form

// |@@| C

import (
	"encoding/json"
	"github.com/gin-gonic/gin"
	"strconv"
	"time"
)

type FormBag struct {
	Invalidations []*Invalidation
}

type Invalidation struct {
	Field   string
	Message string
}

func JsonStringField(key string, m map[string][]byte) string {
	return string(m[key])
}

func JsonTimeField(key string, m map[string][]byte) time.Time {
	t, err := time.Parse("2006-01-02T15:04:05", string(m[key]))
	if err != nil {
		panic(err)
	}
	return t
}

func JsonTextField(key string, m map[string][]byte) string {
	return string(m[key])
}

func JsonJsonField(key string, m map[string][]byte) json.RawMessage {
	return m[key]
}

func JsonIntegerField(key string, m map[string][]byte) int {
	v, _ := strconv.Atoi(string(m[key]))
	return v
}

func JsonDecimalField(key string, m map[string][]byte) float64 {
	v, err := strconv.ParseFloat(string(m[key]), 64)
	if err != nil {
		panic(err)
	}
	return v
}

func JsonBooleanField(key string, m map[string][]byte) bool {
	if string(m[key]) == "true" {
		return true
	}
	return false
}

func PostFormStringField(key string, c *gin.Context) string {
	return c.PostForm(key)
}

func PostFormTimeField(key string, c *gin.Context) time.Time {
	s := c.PostForm(key)
	layout := "2006-01-02T15:04:05"
	if len(s) == len("2006-01-02T15:04") {
		layout = "2006-01-02T15:04"
	}
	v := c.PostForm(key)
	if v == "" {
		v = "2006-01-02T15:04:05"
	}
	t, err := time.Parse(layout, v)
	if err != nil {
		panic(err)
	}
	return t
}

func PostFormTextField(key string, c *gin.Context) string {
	return c.PostForm(key)
}

func PostFormJsonField(key string, c *gin.Context) json.RawMessage {
	return []byte(c.PostForm(key))
}

func PostFormDecimalField(key string, c *gin.Context) float64 {
	v, err := strconv.ParseFloat(c.PostForm(key), 64)
	if err != nil {
		panic(err)
	}
	return v
}

func PostFormIntegerField(key string, c *gin.Context) int {
	v, _ := strconv.Atoi(c.PostForm(key))
	return v
}

func PostFormBooleanField(key string, c *gin.Context) bool {
	if c.PostForm(key) == "on" || c.PostForm(key) == "true" {
		return true
	}
	return false
}

func QueryIntegerField(key string, c *gin.Context) int {
	v, _ := strconv.Atoi(c.Query(key))
	return v
}
func QueryStringField(key string, c *gin.Context) string {
	return c.Query(key)
}

func QueryTimeField(key string, c *gin.Context) time.Time {
	s := c.Query(key)
	layout := "2006-01-02T15:04:05"
	if len(s) == len("2006-01-02T15:04") {
		layout = "2006-01-02T15:04"
	}
	v := c.Query(key)
	if v == "" {
		v = "2006-01-02T15:04:05"
	}
	t, err := time.Parse(layout, v)
	if err != nil {
		panic(err)
	}
	return t
}

func QueryTextField(key string, c *gin.Context) string {
	return c.Query(key)
}

func QueryJsonField(key string, c *gin.Context) json.RawMessage {
	return []byte(c.Query(key))
}

func QueryDecimalField(key string, c *gin.Context) float64 {
	s, has := c.GetQuery(key)
	if !has {
		return 0.00
	}
	v, err := strconv.ParseFloat(s, 64)
	if err != nil {
		panic(err)
	}
	return v
}

func QueryBooleanField(key string, c *gin.Context) bool {
	if c.Query(key) == "on" || c.Query(key) == "true" {
		return true
	}
	return false
}
