package hydrator

// |@@| C

import (
	"slices"
)

type Hydrator struct {
}

type HydratorMod struct {
	Paths []*HydratingPath
}

type HydratingPath struct {
	Path []string
}

func (this *HydratorMod) AddHydratingPath(items ...string) {
	path := &HydratingPath{Path: items}
	this.Paths = append(this.Paths, path)
}

func (this *HydratorMod) Contains(items ...string) bool {
	for _, path := range this.Paths {
		if slices.Equal(path.Path, items) {
			return true
		}
	}
	return false
}

func (this *Hydrator) ModDefaulting(mod *HydratorMod) *HydratorMod {
	if mod != nil {
		return mod
	}
	return &HydratorMod{}
}
