package op

import (
	"gardening/src/lib/message"
	"sync"
	"time"
)

type Op struct {
	Id        string
	Completed bool
	Success   bool
	Error     error
	Result    interface{}
	StartedAt time.Time
	EndedAt   time.Time
	Redirect  string
	Title     string
	Messaged  bool
	Message   message.Message
	mu        sync.Mutex
}

func (this *Op) MarkSuccessful(message string, redirect string, result interface{}) {
	this.mu.Lock()
	defer this.mu.Unlock()
	this.Completed = true
	this.Success = true
	this.Result = result
	this.Redirect = redirect
	this.Message.Title = message
	this.Message.Kind = "success"
	this.EndedAt = time.Now()
}

func (this *Op) MarkFailed(message string, err error, redirect string, result interface{}) {
	this.mu.Lock()
	defer this.mu.Unlock()
	this.Completed = true
	this.Error = err
	this.Result = result
	this.Redirect = redirect
	this.Message.Title = message
	this.Message.Kind = "failure"
	this.EndedAt = time.Now()
}
