package operating_system

// |@@| C

import (
	"context"
	"os"
	"path/filepath"
)

type OperatingSystemInterface interface {
	Kind() string
	Getwd(ctx context.Context) (string, error)
	Getenv(ctx context.Context, key string) string
	Setenv(ctx context.Context, key string, value string) error
	LookupEnv(ctx context.Context, key string) (string, bool)
	Remove(ctx context.Context, name string) error
	RemoveAll(ctx context.Context, name string) error
	WriteFile(ctx context.Context, name string, data []byte, perm os.FileMode) error
	ReadDir(ctx context.Context, name string) ([]os.DirEntry, error)
	Stat(ctx context.Context, name string) (os.FileInfo, error)
	IsNotExist(ctx context.Context, err error) bool
	ReadFile(ctx context.Context, name string) ([]byte, error)
	MkdirAll(ctx context.Context, path string, perm os.FileMode) error
	Rename(ctx context.Context, oldpath, newpath string) error
	Walk(ctx context.Context, root string, fn filepath.WalkFunc) error
	Chmod(ctx context.Context, name string, mode os.FileMode) error
}
